/************************************************************************************
* Mapping of the IO ports and pins.
*
* Author(s): Knud Dyring-Olsen, Jesper Thomsen
*
* (c) Copyright 2005, Freescale, Inc.  All rights reserved.
*
* Freescale Confidential Proprietary
* Digianswer Confidential
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale.
*
* Last Inspected:
* Last Tested:
* History:
*
*	Date
*	--------	----		
*	11/07/06	HS		IOs customized for the HPRFGW application
*
************************************************************************************/
#ifdef FREESCALE_802_15_4_STACK

#pragma info "Make sure that this file is set up correctly"


#ifndef _HPRFGW_RFPORTCONFIG_H_
	#define _HPRFGW_RFPORTCONFIG_H_
#include "hprfgw_rfAppToPlatformConfig.h"
#include "hprfgw_rfSlaveIntToRfApp.h"
#ifdef	TPS6_CLIENT_TEST
 #include "mcf5271.h"
 #include "mcf5271_gpio.h"
 #include "mcf5271.h"
 #include "init5270.h"
#endif

////////////////////////////////////////
///// Define HW port/pin mapping ///////
////////////////////////////////////////

#ifdef	TPS6_CLIENT_TEST

	// RxTx, Attn, PAEnable, AnswTxEn, AntSwRxEn, GPIO5, GPIO6, Reset pin mask 
	#define gMC1319xAttnMask_c   		(1<<0)
	#define gMC1319xResetMask_c  		(1<<1)
	#define gMC1319xRxTxMask_c   		(1<<2)
	#define gMC1319xAntSwRxEnMask_c  	(1<<3)	
	#define gMC1319xAntSwTxEnMask_c  	(1<<4)	
	#define gMC1319xPAEnMask_c  		(1<<5)						 
	#define gMC1319xGPIO1Mask_c  		(1<<6)							 
	#define gMC1319xGPIO2Mask_c  		(1<<7)

	//	GPIO1, GPIO2, GPIO3, GPIO4 port
	//	__TAG remove
	#define MCF_GPIO_PPDSDR_DATAL		(*(vuint8 *)(UINT32)(0x40000000 + 0x100022))

	#define gMC1319xGPIO1Port    		MCF_GPIO_PPDSDR_DATAL				
	#define gMC1319xGPIO2Port    		MCF_GPIO_PPDSDR_DATAL				  

#else //#ifdef	TPS6_CLIENT_TEST

	// RxTx, Attn, PAEnable, AnswTxEn, AntSwRxEn, GPIO5, GPIO6, Reset pin mask 
	#define gMC1319xRxTxMask_c   		(1<<0)							
	#define gMC1319xAttnMask_c   		(1<<1)							
	#define gMC1319xPAEnMask_c  		(1<<2)							 
	#define gMC1319xAntSwTxEnMask_c  	(1<<3)							 
	#define gMC1319xAntSwRxEnMask_c  	(1<<4)							 
	#define gMC1319xGPIO5Mask_c  		(1<<5)							 
	#define gMC1319xGPIO6Mask_c  		(1<<6)		 
	#define gMC1319xResetMask_c  		(1<<7)							


	//	GPIO1, GPIO2, GPIO3, GPIO4 port
	//	__TAG remove
	#define MCF_GPIO_PPDSDR_CS			(*(vuint8 *)(UINT32)(0x40000000 + 0x100025))

	#define gMC1319xGPIO1Port    		MCF_GPIO_PPDSDR_CS				
	#define gMC1319xGPIO2Port    		MCF_GPIO_PPDSDR_CS				  

	//	GPIO1, GPIO2, GPIO3, GPIO4 pin mask	
	#define gMC1319xGPIO1Mask_c  		(1<<1)							
	#define gMC1319xGPIO2Mask_c 		(1<<2)							
	#define gMC1319xGPIO3Mask_c 		(1<<3)							
	#define gMC1319xGPIO4Mask_c 		(1<<4)				

#endif //#ifdef	TPS6_CLIENT_TEST



#endif // #ifdef FREESCALE_802_15_4_STACK

#endif /* PORTCONFIG */
